﻿//DESCRIPTION: Restart numbering sidenotes on every section, spread, or page
// Peter Kahrel - pkahrel@gmail.com

(function () {
	
	var renumber;

	function scriptPath () {
		try {
			return app.activeScript;
		} catch (e) {
			return File (e.fileName);
		}
	}

	function saveData (obj) {
		var f = File (scriptPath().fullName.replace (/\.jsx?(bin)?$/, '.txt'));
		f.open ('w');
		f.write (obj.toSource());
		f.close ();
	}

	function getPrevious () {
		var o = {restart: true, restartWhere: 'Section', objectStyle: 'sidenote'};
		var f = File (scriptPath().fullName.replace (/\.jsx?(bin)?$/, '.txt'));
		if (f.exists){
			o = $.evalFile(f);
		}
		return o;
	}

	//===========================================================================

	function getData () {
		
		var w = new Window ('dialog', "Sidenote options", undefined, {closeButton: false});
			w.alignChildren = 'right';
			w.panel = w.add ('panel {alignChildren: "right"}');
				
				w.panel.line1 = w.panel.add ('group');
					w.prompt = w.panel.line1.add ('checkbox {text: "Restart numbering every:"}');
					w.target = w.panel.line1.add ('dropdownlist', undefined, ['Page', 'Spread', 'Section']);
						
//~ 				w.panel.line2 = w.panel.add ('group');
//~ 					w.panel.line2.add ('statictext {text: "Note object style:"}');
//~ 					w.ostyles = w.panel.line2.add ('dropdownlist', undefined, app.documents[0].objectStyles.itemByRange(4,-1).name);
				
//~ 				w.target.preferredSize.width = w.ostyles.preferredSize.width = 150;
				w.target.preferredSize.width = 150;
			
			w.buttons = w.add ('group');
				w.buttons.add ('button', undefined, 'OK', {name: 'ok'});
				w.buttons.add ('button', undefined, 'Cancel', {name: 'cancel'});
		
			w.prompt.onClick = function () {
				w.target.enabled = this.value;
			}

			w.onShow = function () {
				var previous = getPrevious();
				w.prompt.value = previous.restart;
				w.target.selection = w.target.find (previous.restartWhere);
//~ 				w.ostyles.selection = w.ostyles.find (previous.objectStyle) || 0;
				w.target.enabled = w.prompt.value;
			}

		if (w.show() == 2) exit();
		
		var o = {
			restart: w.prompt.value,
			restartWhere: w.target.selection.text,
//~ 			objectStyle: w.ostyles.selection.text
			objectStyle: 'sidenote'
		}
		saveData (o);
		return o;
	}


	//===========================================================================

	function findNotes () {
		app.findObjectPreferences = null;
		app.findObjectPreferences.appliedObjectStyles = renumber.objectStyle;
		return app.documents[0].findObject();
	}

	function sortNotes (a, b) {
		return  a.storyIndex - b.storyIndex || a.pageOffset - b.pageOffset || a.anchorIndex - b.anchorIndex;
	}

	function getNotes () {
		var list = [];
		var anchor;
		var framePos;
		var notes = findNotes();
		for (var i = 0; i < notes.length; i++) {
			//$.writeln (i);
			if (notes[i].parent instanceof Character) {
				anchor = notes[i].parent;
				framePos = anchor.parentStory.textContainers[0].parentPage.documentOffset;
				list.push ({
					storyIndex: framePos, 
					pageOffset: anchor.parentTextFrames[0].parentPage.documentOffset,
					page: anchor.parentTextFrames[0].parentPage,
					anchorIndex: anchor.index, 
					paragraph: notes[i].paragraphs[0]
				});
			}
		}
		return list;
	}

	function numberByItem (notes, target) {
		for (var i = notes.length-1; i > 0; i--) {
			if (notes[i].page[target] !== notes[i-1].page[target]) {
				notes[i].paragraph.numberingContinue = false;
			} else {
				notes[i].paragraph.numberingContinue = true;
			}
		}
	}

	function numberByDocument (notes) {
		for (var i = notes.length-1; i > 1; i--) {
			notes[i].paragraph.numberingContinue = true;
		}
		notes[0].paragraph.numberingContinue = false;
	}

	//===========================================================================

	// renumber returns e.g. ({restart:true, restartWhere:"Page", objectStyle:"sidenotex"})

	function main () {
		renumber = getData();
		var notes = getNotes ();
		notes = notes.sort (sortNotes);
		if (!renumber.restart) {
			numberByDocument (notes);
		} else switch (renumber.restartWhere) {
			case 'Page': numberByItem (notes, 'documentOffset'); break;
			case 'Section': numberByItem (notes, 'appliedSection'); break; 
			case 'Spread': numberByItem (notes, 'parent');
		}
		app.documents[0].crossReferenceSources.everyItem().update();
	}

	//===========================================================================

	main();

}());